param(
  [string]$VncInstallerPath = "",
  [string]$VncInstallerUrl = "",
  [string]$VncPassword = "Thais29"
)

$ErrorActionPreference = "Stop"

function Ensure-Admin {
  $id = [Security.Principal.WindowsIdentity]::GetCurrent()
  $p = New-Object Security.Principal.WindowsPrincipal($id)
  if (-not $p.IsInRole([Security.Principal.WindowsBuiltinRole]::Administrator)) {
    Write-Host "Run as Administrator." -ForegroundColor Red
    exit 1
  }
}

function Ensure-OpenSSH {
  $cap = Get-WindowsCapability -Online | Where-Object { $_.Name -like 'OpenSSH.Client*' }
  if ($cap.State -ne 'Installed') {
    Add-WindowsCapability -Online -Name OpenSSH.Client~~~~0.0.1.0 | Out-Null
  }
}

function Install-VNC {
  if ($VncInstallerPath -ne "" -and (Test-Path $VncInstallerPath)) {
    Write-Host "Installing TightVNC from local installer..."
    Start-Process -FilePath $VncInstallerPath -ArgumentList "/silent" -Wait
    return
  }
  if ($VncInstallerUrl -ne "") {
    $tmp = Join-Path $env:TEMP "tightvnc-setup.exe"
    Write-Host "Downloading TightVNC installer..."
    Invoke-WebRequest -Uri $VncInstallerUrl -OutFile $tmp
    Start-Process -FilePath $tmp -ArgumentList "/silent" -Wait
    return
  }
  Write-Host "TightVNC installer not provided. Install it manually and re-run this script." -ForegroundColor Yellow
}

function Set-Env {
  setx AGENT_TOKEN "7HIKdbms1OrnFsplGVBC2ROQrMP2UXYn" | Out-Null
  setx SSH_TUNNEL_ENABLED "true" | Out-Null
  setx SSH_USER "ubuntu" | Out-Null
  setx SSH_HOST "remote.thais.ovh" | Out-Null
  setx SSH_PORT "2222" | Out-Null
  setx REVERSE_VNC_PORT "15900" | Out-Null
  setx REVERSE_AGENT_PORT "17171" | Out-Null
}

function Install-Agent {
  Write-Host "Installing Python deps..."
  python -m pip install -r requirements.txt
  Write-Host "Installing service..."
  python service.py install
  python service.py start
}

Ensure-Admin
Ensure-OpenSSH
Install-VNC
Set-Env
Install-Agent

Write-Host "Done. The agent service is running and the SSH tunnel should be active." -ForegroundColor Green
