param(
  [string]$ExePath = "dist\\agent\\agent.exe"
)

$ErrorActionPreference = "Stop"

function Ensure-Admin {
  $id = [Security.Principal.WindowsIdentity]::GetCurrent()
  $p = New-Object Security.Principal.WindowsPrincipal($id)
  if (-not $p.IsInRole([Security.Principal.WindowsBuiltinRole]::Administrator)) {
    Write-Host "Run as Administrator." -ForegroundColor Red
    exit 1
  }
}

Ensure-Admin

if (-not (Test-Path $ExePath)) {
  Write-Host "EXE not found: $ExePath" -ForegroundColor Red
  exit 1
}

$svc = "ThaisCoreRemoteAgent"

sc.exe stop $svc | Out-Null
sc.exe delete $svc | Out-Null

sc.exe create $svc binPath= "`"$ExePath`"" start= auto
sc.exe start $svc

Write-Host "Service installed and started: $svc" -ForegroundColor Green
