import os
import sys
import win32serviceutil
import win32service
import win32event
import servicemanager
import subprocess

class RemoteAgentService(win32serviceutil.ServiceFramework):
    _svc_name_ = "ThaisCoreRemoteAgent"
    _svc_display_name_ = "Thais Core Remote Agent"
    _svc_description_ = "Local enforcement agent for remote sessions."

    def __init__(self, args):
        win32serviceutil.ServiceFramework.__init__(self, args)
        self.stop_event = win32event.CreateEvent(None, 0, 0, None)
        self.proc = None

    def SvcStop(self):
        self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)
        if self.proc:
            self.proc.terminate()
        win32event.SetEvent(self.stop_event)

    def SvcDoRun(self):
        servicemanager.LogMsg(servicemanager.EVENTLOG_INFORMATION_TYPE,
                              servicemanager.PYS_SERVICE_STARTED,
                              (self._svc_name_, ''))

        python = sys.executable
        agent_path = os.path.join(os.path.dirname(__file__), 'agent.py')
        self.proc = subprocess.Popen([python, agent_path])
        win32event.WaitForSingleObject(self.stop_event, win32event.INFINITE)

if __name__ == '__main__':
    win32serviceutil.HandleCommandLine(RemoteAgentService)
