param(
  [string]$ExePath = "dist\\agent\\agent.exe",
  [string]$TaskName = "ThaisCoreRemoteAgentUI"
)

$ErrorActionPreference = "Stop"

function Ensure-Admin {
  $id = [Security.Principal.WindowsIdentity]::GetCurrent()
  $p = New-Object Security.Principal.WindowsPrincipal($id)
  if (-not $p.IsInRole([Security.Principal.WindowsBuiltinRole]::Administrator)) {
    Write-Host "Run as Administrator." -ForegroundColor Red
    exit 1
  }
}

Ensure-Admin

if (-not (Test-Path $ExePath)) {
  Write-Host "EXE not found: $ExePath" -ForegroundColor Red
  exit 1
}

schtasks /delete /tn $TaskName /f | Out-Null
schtasks /create /tn $TaskName /tr "`"$ExePath`"" /sc onlogon /rl HIGHEST /f | Out-Null
schtasks /run /tn $TaskName | Out-Null

Write-Host "Task installed and started: $TaskName" -ForegroundColor Green
