# Windows Agent (Local Enforcement)

## Install
1. Install Python 3.11
2. Install deps:
   - `pip install -r requirements.txt`
3. Set env vars (example):
   - `setx AGENT_TOKEN "7HIKdbms1OrnFsplGVBC2ROQrMP2UXYn"`
   - `setx SSH_TUNNEL_ENABLED "true"`
   - `setx SSH_USER "ubuntu"`
   - `setx SSH_HOST "remote.thais.ovh"`
   - `setx SSH_PORT "2222"`
   - `setx REVERSE_VNC_PORT "15900"`
   - `setx REVERSE_AGENT_PORT "17171"`
4. Install service:
   - `python service.py install`
   - `python service.py start`

## Local REST API (localhost only)
Base URL: `http://127.0.0.1:17171`
Header: `X-Agent-Token: <AGENT_TOKEN>`

Endpoints:
- `POST /status/connected` body `{ "connected": true|false }`
- `POST /input/lock` body `{ "enabled": true|false }`
- `POST /kiosk/enforce` body `{ "allowed_apps": ["app.exe"], "forbidden_apps": ["bad.exe"] }`
- `POST /kiosk/kill-forbidden` body `{}`
- `POST /kiosk/focus` body `{}`
- `POST /overlay/message` body `{ "message": "text" }`
- `GET /health`

## SSH Reverse Tunnel (built-in)
The agent starts and keeps the SSH reverse tunnel alive. It uses:
- VNC tunnel: `-R 15900:127.0.0.1:5900`
- Agent tunnel: `-R 17171:127.0.0.1:17171`

If SSH key auth is used:
- Set `SSH_KEY_PATH` to your private key path.

## Notes
- API binds to 127.0.0.1 only.
- Does not touch audio devices.
- Requires admin privileges for input lock.
